ServerEvents.recipes(event => {
    // Guardian Eye
    event.custom(

        {
            "type": "spirit:soul_engulfing",
            "input": {
            "ingredient": 
                {"item": "lote:inactive_guardian_eye"},
            "multiblock": {
                "pattern": [
                [
                    "   ",
                    " @ ",
                    "   "
                ],
                [
                    "PSP",
                    "SXS",
                    "PSP"
                ]
                ],
                "keys": {
                "S": {
                    "block": "minecraft:sea_lantern"
                },
                "X": {
                    "block": "spirit:compressed_soul_sand"
                },
                "P": {
                    "block": "minecraft:dark_prismarine"
                }
            }
            }},
            "duration": 60,
            "outputItem": "endrem:guardian_eye"
        })
    
    // Corrupted Eye
    event.custom(
        {
            "type": "create:mechanical_crafting",
            "acceptMirrored": false,
            "key": {
                "S": {
                    "item": 'indrev:steel_plate'
                },
                "E": {
                    "item": 'indrev:empty_enhancer'
                },
                "M": {
                    "item": 'indrev:modular_core_activated'
                }
            },
            "pattern": [
                ' SSS ',
                'SEEES',
                'SEMES',
                'SEEES',
                ' SSS '
            ],
            "result": {
                "count": 1,
                "item": 'endrem:corrupted_eye'
            }
        }
    )

    // Black Eye
    event.custom({
        "type": "create:sequenced_assembly",
        "ingredient": {"item": 'echoingdepths:warden_heart'},
        "loops": 3,
        "results": [{"item": 'endrem:black_eye'}],
        "sequence": [
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'echoingdepths:warden_heart'
                    },
                    [
                        {
                            "item": 'minecraft:sculk'
                        }
                    ]
                ],
                "results": [{"item": 'echoingdepths:warden_heart'}]
            },
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'echoingdepths:warden_heart'
                    },
                    [
                        {
                            "item": 'minecraft:echo_shard'
                        }
                    ]
                ],
                "results": [{"item": 'echoingdepths:warden_heart'}]
            },
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'echoingdepths:warden_heart'
                    },
                    [
                        {
                            "item": 'spirit:soul_steel_ingot'
                        }
                    ]
                ],
                "results": [{"item": 'echoingdepths:warden_heart'}]
            }
        ],
        "transitionalItem": {"item": 'echoingdepths:warden_heart'}
    })
})

// Cryptic Eye
BlockEvents.rightClicked('minecraft:enchanting_table', event => {  
    const {block, player, hand, server} = event
    const {x,y,z} = block
    let dull = 0
    if (hand != "MAIN_HAND") return;
    let item = player.getMainHandItem()
    if (item != 'lote:dull_eye') return
    event.cancel()
    if (player.xpLevel < 30) dull = 1
    item.count--
    let itemEntity = block.createEntity("item")
    if (dull == 1) itemEntity.item = 'lote:dull_eye'
    if (dull == 0) {
        itemEntity.item = 'endrem:cryptic_eye'
        player.xpLevel = player.xpLevel - 30
    }
    itemEntity.y+=0.8
    itemEntity.x+=0.5
    itemEntity.z+=0.5
    itemEntity.item.count = 1
    itemEntity.noGravity = true
    itemEntity.motionY = 0.03
    itemEntity.pickUpDelay = 100
    server.scheduleInTicks(20, (_) =>{
        server.runCommandSilent(`execute in ${block.dimension} run particle minecraft:effect ${x} ${y+1.2} ${z} 0 0 0 1 100 force`)
        itemEntity.spawn()
        if (dull == 1) actionbar(player.username, 'The eye refuses to enchant')
    })
})